<?php
/**
 * SCREETS © 2024
 *
 * SCREETS, d.o.o. Sarajevo. All rights reserved.
 * This  is  commercial  software,  only  users  who have purchased a valid
 * license  and  accept  to the terms of the  License Agreement can install
 * and use this program.
 *
 * @package scxi
 * @author screets
 * @link https://screets.io
 */

if (!defined('ABSPATH')) { exit; }

/**
 * Get site domain (i.e. returns "screets.com").
 *
 * @since 3.4.0
 * @return string
 */
function fn_scxi_getSiteDomain () {
  $url = parse_url(get_site_url());

  if ($url == false && !isset($url['host'])) {
    return '';
  }

  return str_replace('www.', '', $url['host']);
}